﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ExampleClientNet40_Test.com.creditsafe.testwebservices;
using System.Net;
using System.ServiceModel.Security;
using System.Configuration;

namespace ExampleClientNet40_Test
{
    class Program
    {
        static void Main(string[] args)
        {
            using (var client = new GlobalDataServiceClient())
            {
                client.ClientCredentials.UserName.UserName = ConfigurationManager.AppSettings["UserName"];
                client.ClientCredentials.UserName.Password = ConfigurationManager.AppSettings["Password"];
                
                var countries = client.GetCountries(new CountriesListingFilter() { OnlineReports = true, OnlineReportsSpecified = true });

                Console.WriteLine("Get Countries");
                foreach (var country in countries.Countries)
                {
                    Console.Write(country.Code + " ");
                }

                var countryCode = CountryCode.GB;

                Console.WriteLine();
                var searchCriteria = client.GetPossibleSearchCriteria(new CountryCode[] { countryCode });

                var companies = client.FindCompanies(new CountryCode[] { countryCode },
                    new SearchCriteria()
                    {
                        Name = new QueryString()
                        {
                            Value = "harrods",
                            MatchType = QueryMatchType.MatchBeginning
                        }
                    }, null, "");

                Console.WriteLine("Found companies:");
                foreach (var company in companies.Companies)
                {
                    Console.WriteLine("Id: " + company.Id);
                    Console.WriteLine("Name: " + company.Name);
                    Console.WriteLine("RegistrationNumber: " + company.RegistrationNumber);
                    Console.WriteLine("---");
                }

                var reports = client.RetrieveCompanyOnlineReport(companies.Companies[0].Id, CompanyReportType.Full, Language.EN, null, "", false, null, "");

                Console.WriteLine("Retrieve report:");
                foreach (var report in reports.Reports)
                {
                    Console.WriteLine("Order number: " + report.OrderNumber);
                    Console.WriteLine("Language: " + report.Language);
                }

                // Must cast to an exact report type to be able to get to its properties.
                LtdCompanyFullReport reportInstance = (LtdCompanyFullReport)reports.Reports[0];

                // Note: To be called only if you have monitoring enabled.
                //var portfolios = client.CreatePortfolio(new PortfolioSettings() { Name = "ExampleClientNet40 Portfolio", Enabled = true });
            }

            Console.ReadKey();
        }
    }
}
